/*
 * Decompiled with CFR 0.152.
 */
package com.bstek.bdf3.security.ui.builder;

import com.bstek.bdf3.security.ui.builder.Builder;
import com.bstek.bdf3.security.ui.builder.ViewComponent;
import com.bstek.bdf3.security.ui.utils.ControlUtils;
import com.bstek.dorado.common.MetaDataSupport;
import com.bstek.dorado.view.AbstractViewElement;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DefaultBuilder
implements Builder<AbstractViewElement> {
    @Value(value="${bdf3.componentPermissionFlat}")
    private boolean componentPermissionFlat;

    @Override
    public void build(AbstractViewElement control, ViewComponent parent, ViewComponent root) {
        if (ControlUtils.isNoSecurtiy((MetaDataSupport)control)) {
            return;
        }
        if (ControlUtils.supportControlType(control)) {
            ViewComponent component = new ViewComponent();
            component.setId(control.getId());
            component.setIcon(this.getIcon(control));
            component.setEnabled(true);
            component.setName(this.getName(control));
            if (this.componentPermissionFlat) {
                root.addChildren(component);
            } else {
                parent.addChildren(component);
            }
        }
    }

    protected String getIcon(AbstractViewElement control) {
        return ">dorado/res/" + control.getClass().getName().replaceAll("\\.", "/") + ".png";
    }

    protected String getName(AbstractViewElement control) {
        return control.getClass().getSimpleName();
    }

    @Override
    public boolean support(Object control) {
        return false;
    }
}

